/*
 * Decompiled with CFR 0.152.
 */
package api.graphics.geometry;

import api.graphics.Camera;
import api.graphics.Shader;
import api.graphics.geometry.Triangle;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL45;

public class ShapeDrawer {
    private int VAO;
    private int VBO;
    private int maxVertexBufferSize = 1200000;
    private Shader shader;

    public void prepare() {
        this.shader = new Shader("C:\\ProgramData\\supercad\\shaders\\shape shader\\vertx.glsl", "C:\\ProgramData\\supercad\\shaders\\shape shader\\frag.glsl");
        this.VAO = GL45.glGenVertexArrays();
        GL45.glBindVertexArray((int)this.VAO);
        this.VBO = GL45.glGenBuffers();
        GL45.glBindBuffer((int)34962, (int)this.VBO);
        GL45.glBufferData((int)34962, (long)this.maxVertexBufferSize, (int)35048);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)12, (long)0L);
        GL45.glBindVertexArray((int)0);
    }

    public void begin(Camera camera) {
        this.shader.use();
        this.shader.setMat4("vp", camera.GetProjectionMatrix().mul((Matrix4fc)camera.GetViewMatrix()));
        this.setOpacity(1.0f);
    }

    public void begin(Matrix4f vp) {
        this.shader.use();
        this.shader.setMat4("vp", vp);
        this.setOpacity(1.0f);
    }

    public void drawPoints(Vector3f[] points, float pointSize, Vector3f color, Matrix4f transform) {
        float[] vertices = new float[points.length * 3];
        int c = 0;
        int i = 0;
        while (i < points.length) {
            vertices[c++] = points[i].x;
            vertices[c++] = points[i].y;
            vertices[c++] = points[i].z;
            ++i;
        }
        GL45.glBindBuffer((int)34962, (int)this.VBO);
        GL45.glBufferSubData((int)34962, (long)0L, (float[])vertices);
        GL45.glBindBuffer((int)34962, (int)0);
        this.shader.setMat4("model", transform);
        this.shader.setVec3("color", color);
        GL45.glBindVertexArray((int)this.VAO);
        GL45.glPointSize((float)pointSize);
        GL45.glDrawArrays((int)0, (int)0, (int)points.length);
    }

    public void end() {
        GL45.glDepthFunc((int)515);
        GL45.glPointSize((float)1.0f);
        GL45.glLineWidth((float)1.0f);
        GL45.glBindVertexArray((int)0);
        GL45.glBindBuffer((int)34962, (int)0);
    }

    public void drawLines(Vector3f[] points, float lineWidth, Vector3f color, Matrix4f transform) {
        float[] vertices = new float[points.length * 3];
        int c = 0;
        int i = 0;
        while (i < points.length) {
            vertices[c++] = points[i].x;
            vertices[c++] = points[i].y;
            vertices[c++] = points[i].z;
            ++i;
        }
        GL45.glBindBuffer((int)34962, (int)this.VBO);
        GL45.glBufferSubData((int)34962, (long)0L, (float[])vertices);
        GL45.glBindBuffer((int)34962, (int)0);
        this.shader.setMat4("model", transform);
        this.shader.setVec3("color", color);
        GL45.glBindVertexArray((int)this.VAO);
        GL45.glLineWidth((float)lineWidth);
        GL45.glDrawArrays((int)1, (int)0, (int)points.length);
    }

    public void drawTriangle(Vector3f v0, Vector3f v1, Vector3f v2, Matrix4f model, Vector3f color) {
        float[] vertices = new float[]{v0.x, v0.y, v0.z, v1.x, v1.y, v1.z, v2.x, v2.y, v2.z};
        GL45.glBindVertexArray((int)this.VAO);
        GL45.glBindBuffer((int)34962, (int)this.VBO);
        GL45.glBufferSubData((int)34962, (long)0L, (float[])vertices);
        this.shader.setMat4("model", model);
        this.shader.setVec3("color", color);
        GL45.glLineWidth((float)4.0f);
        GL45.glDrawArrays((int)4, (int)0, (int)3);
    }

    public void drawTrianglesOutlined(Triangle[] triangles, float lineWidth, Matrix4f model, Vector3f color) {
        Vector3f[] vertices = new Vector3f[triangles.length * 3 * 2];
        int c = 0;
        Triangle[] triangleArray = triangles;
        int n = triangles.length;
        int n2 = 0;
        while (n2 < n) {
            Triangle tr = triangleArray[n2];
            vertices[c++] = tr.getV0();
            vertices[c++] = tr.getV1();
            vertices[c++] = tr.getV1();
            vertices[c++] = tr.getV2();
            vertices[c++] = tr.getV2();
            vertices[c++] = tr.getV0();
            ++n2;
        }
        this.drawLines(vertices, lineWidth, color, model);
    }

    public void setOpacity(float opacity) {
        this.shader.setFloat("opacity", opacity);
    }
}

