/*
 * Decompiled with CFR 0.152.
 */
package api.graphics.geometry;

import java.util.Objects;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Edge {
    Vector3f v0;
    Vector3f v1;

    public Edge(Vector3f v0, Vector3f v1) {
        this.v0 = v0;
        this.v1 = v1;
    }

    float len2() {
        return this.v0.distanceSquared((Vector3fc)this.v1);
    }

    public Vector3f getV0() {
        return this.v0;
    }

    public void setV0(Vector3f v0) {
        this.v0 = v0;
    }

    public Vector3f getV1() {
        return this.v1;
    }

    public void setV1(Vector3f v1) {
        this.v1 = v1;
    }

    public String toString() {
        return "Edge [v0=" + String.valueOf(this.v0) + ", v1=" + String.valueOf(this.v1) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.v0, this.v1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        float d = this.len2();
        if ((double)(d / (other.len2() + 1.0E-6f)) < 0.001) {
            return false;
        }
        float epsilon = d / 1000.0f;
        if (this.v0.distanceSquared((Vector3fc)other.v0) < epsilon && this.v1.distanceSquared((Vector3fc)other.v1) < epsilon) {
            return true;
        }
        return this.v0.distanceSquared((Vector3fc)other.v1) < epsilon && this.v1.distanceSquared((Vector3fc)other.v0) < epsilon;
    }
}

