/*
 * Decompiled with CFR 0.152.
 */
package org.frs.debitage.engine.core.evalutor;

import java.time.Instant;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class TestExcutorService {
    public static void main(String[] args) {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        int i = 0;
        while (i <= 10) {
            int ii = i++;
            executor.submit(() -> TestExcutorService.loop(ii));
        }
        System.out.println(String.valueOf(executor.isShutdown()) + " is isTerminated");
        System.out.println(String.valueOf(executor.isTerminated()) + " is isTerminated");
        try {
            executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println(String.valueOf(executor.isShutdown()) + " is isTerminated");
        System.out.println(String.valueOf(executor.isTerminated()) + " is isTerminated");
        executor.shutdown();
        System.out.println(String.valueOf(executor.isShutdown()) + " is isTerminated");
        System.out.println(String.valueOf(executor.isTerminated()) + " is isTerminated");
    }

    public static void loop(int index) {
        Date deb = new Date();
        Instant ideb = Instant.now();
        System.out.println(String.valueOf(index) + " program start at " + deb.toGMTString() + "(" + ideb.toEpochMilli() + ")" + ":" + deb.getSeconds());
        int fact = TestExcutorService.getFactorial2(20000000);
        Date end = new Date();
        Instant iend = Instant.now();
        System.out.println(String.valueOf(index) + " program ended in " + end.toGMTString() + "(" + iend.toEpochMilli() + ")" + ":" + end.getSeconds() + "with value= " + fact);
    }

    public static int getFactorial(int f) {
        if (f <= 1) {
            return 1;
        }
        return f * TestExcutorService.getFactorial(f - 1);
    }

    public static int getFactorial2(int f) {
        int result = 1;
        int i = 1;
        while (i <= f) {
            result += i;
            ++i;
        }
        return result;
    }
}

