package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.badlogic.gdx.Gdx;

import dressing.events.EventDriver;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.sceneconfig.FloorSettingComposite;
import dressing.ui.shapedrawer.FinalPage;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.PlinthObject;
import gdxapp.scenes.SceneEvent;
import gdxapp.scenes.ScenePreferences;
import geometry.CompoundObject;
import geometry.ShapeDrawer;

public class SocleWizardPage extends WizardPage implements FinalPage {

	
	private SocleSettingComposite composite;
	private PlinthObject plinthObject;
	
	public static SocleWizardPage  instance;
		
	public static SocleWizardPage getInstance() {
		return instance;
	}
	
	public SocleWizardPage() {
		super("socleWizardPage");
		setTitle("Création du socle");
		createNewPlinth();
	}

	private void createNewPlinth() {
		try {
			CompoundObject geometry =  ShapeDrawer.getInstance().getTemporaryObject();
			geometry.getBorder().setMaterial(AssetsTextures.getInstance().getMaterial("Plastique"));
			this.plinthObject = new PlinthObject(geometry);
		}catch (Exception e) {
			System.err.println("failed to create new plinth");
			e.printStackTrace();
		}
	}

	@Override
	public void createControl( Composite grandparent) {
		composite = new SocleSettingComposite(grandparent, SWT.EMBEDDED, plinthObject);
		grandparent.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		composite.setParent(grandparent);
		setControl(composite);
		getWizard().getContainer().updateButtons();
	}


	@Override
	public boolean isPageComplete() {
		return true;
	}

	@Override
	public void onHide() {
		ProjectManager.getManager().getCurrentScene().addActor(plinthObject, true);
		ShapeDrawer.getInstance().finish();
		
//		float[] rgb = new  float[] {color.getRed()/1000f, color.getGreen()/1000f, color.getBlue()/1000f};
//		this.plinthObject.setColor(rgb);
//		this.plinthObject.setHeight(composite.getHeight());
//		this.plinthObject.setThickness(composite.getThickness());
//		this.plinthObject.getRealWorldDimension();
//		this.plinthObject.setGeometry(ShapeDrawer.getInstance().getTemporaryObject());
//		this.plinthObject.prepareModel();
		
	}
	
}
