package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.controller.ProjectCreator;
import dressing.model.DesignException;
import dressing.ui.engine3d.sceneconfig.FloorSettingComposite;
import gdxapp.scenes.ScenePreferences;

public class FloorConfigWizardPage extends WizardPage implements PropertyChangeListener{
	
	
	private FloorSettingComposite composite;
	private ScenePreferences preferences;
	
	protected FloorConfigWizardPage(String pageName) {
		super(pageName);
	}
	
	protected FloorConfigWizardPage(ScenePreferences preferences) {
		super("Apparence du sol");
		setTitle("Apparence du sol");
		this.preferences = preferences;
		this.preferences.addPropertyChangeListener(this);
	}

	@Override
	public void createControl(Composite parent) {
		composite = new FloorSettingComposite(parent, SWT.EMBEDDED, preferences);
		setControl(composite);
	//	getWizard().getContainer().updateButtons();

	}
	public void clearlistners() {
		preferences.removePropertyChangeListener(this);

	}

	@Override
	public boolean isPageComplete() {
		return preferences.getFloorMtl() != null;
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if(isCurrentPage())
		{
			if (FloorConfigWizardPage.this != null) {
				setPageComplete(isPageComplete());
				if (getWizard().getContainer() != null)
					getContainer().updateButtons();
			}
		}
	}
	
	

}
