package dressing.ui;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.model.Chant;
import dressing.model.DesignException;
import dressing.model.IUpdateStructure;
import dressing.model.Materiaux;
import dressing.model.ModelProvider;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;

public class Piece2DComposite extends Composite implements IUpdateStructure{

	private DataBindingContext m_bindingContext;
	private dressing.model.Piece2D piece2D = new dressing.model.Piece2D();
	private Text nameText;
	private Spinner pieceLSpinner;
	private Spinner pieceHSpinner;
	private Spinner positionetagereSpinner;
	private Spinner epaisseurSpinner;
	private Composite composite;
	private TabFolder tabFolder;
	private TabItem tbtmAcceuil;
	private TabItem tbtmNewItem;
	private Composite composite_1;
	private Composite composite_2;
	private Label lblPiece;
	private Label lblNewLabel;
	private Label lblNewLabel_1;
	private Label lblNewLabel_2;
	private Label lblNewLabel_3;
	private Label lblNewLabel_4;
	private Combo combo_Chant1;
	private ComboViewer comboViewerChant1;
	private Combo combo_Chant2;
	private ComboViewer comboViewerChant2;
	private Combo combo_Chant3;
	private ComboViewer comboViewerChant3;
	private Combo combo_Chant4;
	private ComboViewer comboViewerChant4;
	ControlDecoration deco;
	private MDirtyable dirty;
	private int updatestragey = UpdateValueStrategy.POLICY_UPDATE;
	private Label lbllongChant1;
	private Label lbllongChant2;
	private Label lbllongChant3;
	private Label lbllongChant4;
	public Piece2DComposite(Composite parent, int style, dressing.model.Piece2D newPiece2D, int updatestrategy) {
		this(parent, style);
		this.updatestragey = updatestrategy;
		setPiece2D(newPiece2D);
		if (piece2D != null) {
			m_bindingContext = initDataBindings();
			custominitDataBindings();
		}
	}

	public Piece2DComposite(Composite parent, int style) {
		super(parent, style);
		setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
		setLayout(new GridLayout(2, false));

		lblPiece = new Label(this, SWT.NONE);
		lblPiece.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
		lblPiece.setFont(SWTResourceManager.getFont("Segoe UI", 16, SWT.NORMAL));
		GridData gd_lblPiece = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_lblPiece.widthHint = 75;
		gd_lblPiece.heightHint = 46;
		lblPiece.setLayoutData(gd_lblPiece);
		lblPiece.setText("Piece");

		lblNewLabel = new Label(this, SWT.NONE);
		lblNewLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_YELLOW));
		lblNewLabel.setForeground(SWTResourceManager.getColor(SWT.COLOR_RED));
		GridData gd_lblNewLabel = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_lblNewLabel.widthHint = 358;
		gd_lblNewLabel.heightHint = 46;
		lblNewLabel.setLayoutData(gd_lblNewLabel);

		composite = new Composite(this, SWT.NONE);
		GridData gd_composite = new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1);
		gd_composite.widthHint = 411;
		gd_composite.heightHint = 184;
		composite.setLayoutData(gd_composite);
		composite.setLayout(new GridLayout(1, false));

		tabFolder = new TabFolder(composite, SWT.NONE);
		GridData gd_tabFolder = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_tabFolder.heightHint = 146;
		gd_tabFolder.widthHint = 427;
		tabFolder.setLayoutData(gd_tabFolder);

		tbtmAcceuil = new TabItem(tabFolder, SWT.NONE);
		tbtmAcceuil.setText("Acceuil");

		composite_1 = new Composite(tabFolder, SWT.NONE);
		tbtmAcceuil.setControl(composite_1);
		composite_1.setLayout(new GridLayout(2, false));

		Label label = new Label(composite_1, SWT.NONE);
		label.setText("Name:");

		nameText = new Text(composite_1, SWT.BORDER | SWT.SINGLE);
		GridData gd_nameText = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_nameText.widthHint = 313;
		nameText.setLayoutData(gd_nameText);

		Label label_1 = new Label(composite_1, SWT.NONE);
		label_1.setText("PieceL:");

		pieceLSpinner = new Spinner(composite_1, SWT.BORDER | SWT.READ_ONLY);
		pieceLSpinner.setEnabled(false);
		pieceLSpinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		pieceLSpinner.setMaximum(100000);

		Label label_2 = new Label(composite_1, SWT.NONE);
		label_2.setText("PieceH:");

		pieceHSpinner = new Spinner(composite_1, SWT.BORDER | SWT.READ_ONLY);
		pieceHSpinner.setEnabled(false);
		pieceHSpinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		pieceHSpinner.setMaximum(100000);

		Label label_3 = new Label(composite_1, SWT.NONE);
		label_3.setText("Positionetagere:");

		positionetagereSpinner = new Spinner(composite_1, SWT.BORDER | SWT.READ_ONLY);
		positionetagereSpinner.setEnabled(false);
		GridData gd_positionetagereSpinner = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_positionetagereSpinner.widthHint = 274;
		positionetagereSpinner.setLayoutData(gd_positionetagereSpinner);
		positionetagereSpinner.setMaximum(10000000);

		Label label_4 = new Label(composite_1, SWT.NONE);
		label_4.setText("Epaisseur:");

		epaisseurSpinner = new Spinner(composite_1, SWT.BORDER | SWT.READ_ONLY);
		epaisseurSpinner.setEnabled(false);
		epaisseurSpinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		epaisseurSpinner.setMaximum(100000);

		tbtmNewItem = new TabItem(tabFolder, SWT.NONE);
		tbtmNewItem.setText("Chants");

		composite_2 = new Composite(tabFolder, SWT.NONE);
		tbtmNewItem.setControl(composite_2);
		composite_2.setLayout(new GridLayout(3, false));

		lblNewLabel_1 = new Label(composite_2, SWT.NONE);
		GridData gd_lblNewLabel_1 = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_lblNewLabel_1.widthHint = 61;
		lblNewLabel_1.setLayoutData(gd_lblNewLabel_1);
		lblNewLabel_1.setText("Chant 1");

		comboViewerChant1 = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_Chant1 = comboViewerChant1.getCombo();
		combo_Chant1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewerChant1.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Chant) {
		        	 Chant chnt = (Chant) element;
		             return chnt.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewerChant1.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewerChant1.setInput(ModelProvider.getListChant());
		
		lbllongChant1 = new Label(composite_2, SWT.NONE);
		lblNewLabel_2 = new Label(composite_2, SWT.NONE);
		lblNewLabel_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_2.setText("Chant 2");

		comboViewerChant2 = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_Chant2 = comboViewerChant2.getCombo();
		combo_Chant2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewerChant2.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Chant) {
		        	 Chant chnt = (Chant) element;
		             return chnt.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewerChant2.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewerChant2.setInput(ModelProvider.getListChant());
		
		lbllongChant2 = new Label(composite_2, SWT.NONE);
		lblNewLabel_3 = new Label(composite_2, SWT.NONE);
		lblNewLabel_3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_3.setText("Chant 3");

		comboViewerChant3 = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_Chant3 = comboViewerChant3.getCombo();
		combo_Chant3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewerChant3.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Chant) {
		        	 Chant chnt = (Chant) element;
		             return chnt.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewerChant3.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewerChant3.setInput(ModelProvider.getListChant());
		
		lbllongChant3 = new Label(composite_2, SWT.NONE);
		lblNewLabel_4 = new Label(composite_2, SWT.NONE);
		lblNewLabel_4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_4.setText("Chant 4");

		comboViewerChant4 = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_Chant4 = comboViewerChant4.getCombo();
		combo_Chant4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lbllongChant4 = new Label(composite_2, SWT.NONE);
		comboViewerChant4.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Chant) {
		        	 Chant chnt = (Chant) element;
		             return chnt.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewerChant4.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewerChant4.setInput(ModelProvider.getListChant());

		if (piece2D != null) {
			m_bindingContext = custominitDataBindings();
			m_bindingContext = initDataBindings();
		}
	
	//Ajouter le controle de dirty
				makedirtycontroller(this);	
				makeerrorhandler(lblNewLabel);
				new Label(this, SWT.NONE);
				new Label(this, SWT.NONE);
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public dressing.model.Piece2D getPiece2D() {
		return piece2D;
	}

	public void setPiece2D(dressing.model.Piece2D newPiece2D) {
		setPiece2D(newPiece2D, true);
	}

	public void setPiece2D(dressing.model.Piece2D newPiece2D, boolean update) {
		piece2D = newPiece2D;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (piece2D != null) {
				m_bindingContext = custominitDataBindings();
			}
		}
	}

	protected DataBindingContext custominitDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue nameObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(nameText);
		IObservableValue nameObserveValue = BeanProperties.value("name").observe(piece2D);
		bindingContext.bindValue(nameObserveWidget, nameObserveValue, null, null);
		//
		IObservableValue pieceLObserveWidget = WidgetProperties.spinnerSelection().observe(pieceLSpinner);
		IObservableValue pieceLObserveValue = BeanProperties.value("pieceL").observe(piece2D);
		bindingContext.bindValue(pieceLObserveWidget, pieceLObserveValue,
				new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
		//
		IObservableValue pieceHObserveWidget = WidgetProperties.spinnerSelection().observe(pieceHSpinner);
		IObservableValue pieceHObserveValue = BeanProperties.value("pieceH").observe(piece2D);
		bindingContext.bindValue(pieceHObserveWidget, pieceHObserveValue,
				new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
		//
		IObservableValue positionetagereObserveWidget = WidgetProperties.spinnerSelection().observe(positionetagereSpinner);
		IObservableValue positionetagereObserveValue = BeanProperties.value("positionetagere").observe(piece2D);
		bindingContext.bindValue(positionetagereObserveWidget, positionetagereObserveValue,
				new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
		//
		IObservableValue epaisseurObserveWidget = WidgetProperties.spinnerSelection().observe(epaisseurSpinner);
		IObservableValue epaisseurObserveValue = BeanProperties.value("epaisseur").observe(piece2D);
		bindingContext.bindValue(epaisseurObserveWidget, epaisseurObserveValue,
				new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
		//

		FocusListener focus = new FocusListener() {

			@Override
			public void focusLost(FocusEvent e) {
				// TODO Auto-generated method stub
				bindingContext.updateModels();
			}

			@Override
			public void focusGained(FocusEvent e) {
				// TODO Auto-generated method stub

			}
		};
		pieceLSpinner.addFocusListener(focus);
		pieceHSpinner.addFocusListener(focus);
		positionetagereSpinner.addFocusListener(focus);
		epaisseurSpinner.addFocusListener(focus);

		return bindingContext;
	}
	
	public MDirtyable getDirty() {
		return dirty;
	}

	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	//Pour corriger le Bug de spinner que selctionne tous apres chaque saisie
	private void updateCaretposition(Control ctr)
	{
		Event ke = new Event();
        ke.type = SWT.MENU_KEYBOARD;
        ke.keyCode = SWT.ARROW_RIGHT;
        ctr.getDisplay().post(ke);
	}
	protected void makeControldirtyController(Control ctr) {
		if(ctr instanceof Text)
		{
			((Text) ctr).addKeyListener(new KeyListener() {
				
				@Override
				public void keyReleased(KeyEvent e) {
					// TODO Auto-generated method stub
					updateDirty();
				}
				
				@Override
				public void keyPressed(KeyEvent e) {
					// TODO Auto-generated method stub
					
				}
			});
		}
		else
		{
			ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
		}
		if(ctr instanceof Spinner)
		{
			ctr.addListener(SWT.Selection, event->updateCaretposition(ctr));
		}
	}
	protected void makedirtycontroller(Composite composite)
	{
		//Faire la mise ajour des controel pour qui enregistre le dirty
				Control [] ctrl = this.getChildren();
			
				for(Control ctr : composite.getChildren())
				{	
					if(ctr instanceof Composite ) {
						for(Control ctrs : ((Composite)ctr).getChildren()) {
							if(ctrs instanceof Composite) {
								makedirtycontroller((Composite) ctrs);
							}else {
								makeControldirtyController(ctrs);
							}
						}
					}
					
					makeControldirtyController(ctr);		
					
				}
				if(!(composite instanceof TabFolder)) {
					makeControldirtyController(composite);
				}
	}

	protected void makeerrorhandler(Control control)
	{
		
		deco = new ControlDecoration(control, SWT.TOP | SWT.RIGHT);
		// re-use an existing image
		Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR)
				.getImage();
		// set description and image
		deco.setImage(image);
		// hide deco if not in focus
		deco.setShowOnlyOnFocus(false);
		deco.hide();
	}
	@Override
	public void run() throws DesignException {
		// TODO Auto-generated method stub
		try
		{
			piece2D.setErrorexist(false);
			piece2D.setErrormsg("");
			m_bindingContext.updateModels();
			piece2D.update();
			deco.setDescriptionText("");
			deco.hide();
		}
		catch( Exception e)
		{
			piece2D.setErrorexist(true);
			piece2D.setErrormsg(e.getMessage());
			deco.setDescriptionText(e.getMessage());
			deco.show();
		}
	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		m_bindingContext.updateTargets();
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue nameObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(nameText);
		IObservableValue nameObserveValue = BeanProperties.value("name").observe(piece2D);
		bindingContext.bindValue(nameObserveWidget, nameObserveValue, null, null);
		//
		IObservableValue pieceLObserveWidget = WidgetProperties.spinnerSelection().observe(pieceLSpinner);
		IObservableValue pieceLObserveValue = BeanProperties.value("pieceL").observe(piece2D);
		bindingContext.bindValue(pieceLObserveWidget, pieceLObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
		//
		IObservableValue pieceHObserveWidget = WidgetProperties.spinnerSelection().observe(pieceHSpinner);
		IObservableValue pieceHObserveValue = BeanProperties.value("pieceH").observe(piece2D);
		bindingContext.bindValue(pieceHObserveWidget, pieceHObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
		//
		IObservableValue positionetagereObserveWidget = WidgetProperties.spinnerSelection().observe(positionetagereSpinner);
		IObservableValue positionetagereObserveValue = BeanProperties.value("positionetagere").observe(piece2D);
		bindingContext.bindValue(positionetagereObserveWidget, positionetagereObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
		//
		IObservableValue epaisseurObserveWidget = WidgetProperties.spinnerSelection().observe(epaisseurSpinner);
		IObservableValue epaisseurObserveValue = BeanProperties.value("epaisseur").observe(piece2D);
		bindingContext.bindValue(epaisseurObserveWidget, epaisseurObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), null);
		//
		IObservableValue observeTextLblNewLabelObserveWidget = WidgetProperties.text().observe(lblNewLabel);
		IObservableValue errormsgPiece2DObserveValue = BeanProperties.value("errormsg").observe(piece2D);
		bindingContext.bindValue(observeTextLblNewLabelObserveWidget, errormsgPiece2DObserveValue, null, null);
		//
		IObservableValue observeVisibleLblNewLabelObserveWidget = WidgetProperties.visible().observe(lblNewLabel);
		IObservableValue errorexistPiece2DObserveValue = BeanProperties.value("errorexist").observe(piece2D);
		bindingContext.bindValue(observeVisibleLblNewLabelObserveWidget, errorexistPiece2DObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewerChant4 = ViewerProperties.singleSelection().observe(comboViewerChant4);
		IObservableValue chant4Piece2DObserveValue = BeanProperties.value("chant4").observe(piece2D);
		bindingContext.bindValue(observeSingleSelectionComboViewerChant4, chant4Piece2DObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewerChant3 = ViewerProperties.singleSelection().observe(comboViewerChant3);
		IObservableValue chant3Piece2DObserveValue = BeanProperties.value("chant3").observe(piece2D);
		bindingContext.bindValue(observeSingleSelectionComboViewerChant3, chant3Piece2DObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewerChant2 = ViewerProperties.singleSelection().observe(comboViewerChant2);
		IObservableValue chant2Piece2DObserveValue = BeanProperties.value("chant2").observe(piece2D);
		bindingContext.bindValue(observeSingleSelectionComboViewerChant2, chant2Piece2DObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewerChant1 = ViewerProperties.singleSelection().observe(comboViewerChant1);
		IObservableValue chant1Piece2DObserveValue = BeanProperties.value("chant1").observe(piece2D);
		bindingContext.bindValue(observeSingleSelectionComboViewerChant1, chant1Piece2DObserveValue, null, null);
		//
		IObservableValue observeTextLbllongChant1ObserveWidget = WidgetProperties.text().observe(lbllongChant1);
		IObservableValue longchant1Piece2DObserveValue = BeanProperties.value("longchant1").observe(piece2D);
		bindingContext.bindValue(observeTextLbllongChant1ObserveWidget, longchant1Piece2DObserveValue, null, null);
		//
		IObservableValue observeTextLbllongChant2ObserveWidget = WidgetProperties.text().observe(lbllongChant2);
		IObservableValue longchant2Piece2DObserveValue = BeanProperties.value("longchant2").observe(piece2D);
		bindingContext.bindValue(observeTextLbllongChant2ObserveWidget, longchant2Piece2DObserveValue, null, null);
		//
		IObservableValue observeTextLbllongChant3ObserveWidget = WidgetProperties.text().observe(lbllongChant3);
		IObservableValue longchant3Piece2DObserveValue = BeanProperties.value("longchant3").observe(piece2D);
		bindingContext.bindValue(observeTextLbllongChant3ObserveWidget, longchant3Piece2DObserveValue, null, null);
		//
		IObservableValue observeTextLbllongChant4ObserveWidget = WidgetProperties.text().observe(lbllongChant4);
		IObservableValue longchant4Piece2DObserveValue = BeanProperties.value("longchant4").observe(piece2D);
		bindingContext.bindValue(observeTextLbllongChant4ObserveWidget, longchant4Piece2DObserveValue, null, null);
		//
		return bindingContext;
	}
}
