package dressing.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

import dressing.config.WorkspaceConfiguration;
import dressing.model.ModelProvider;
import dressing.ui.ProgressBarMonitor;
import dressing.ui.engine3d.SceneTexture;

public class ImageLabelLoader implements Runnable {
		
	public ImageLabelLoader() {
		super();
	}

	@Override
	public void run() {
		int count = ModelProvider.getTextures().size();
		int counter = 0;
		Display.getDefault().syncExec(new Runnable() {
			
			@Override
			public void run() {
				ProgressBarMonitor.setTasks(ModelProvider.getTextures().size());
			}
		});
		
		for(SceneTexture sceneTexture: ModelProvider.getTextures()) {
			try {
				ImageData data = null;
				if(new File(sceneTexture.getMinifiedPath()).exists()) {
					data = new ImageData(new FileInputStream(sceneTexture.getMinifiedPath()));
				}else {
					 data = new ImageData(new FileInputStream(sceneTexture.getPath())).scaledTo(256, 256);
					 saveMinifiedImage(data, sceneTexture.getMinifiedPath());
				}
				sceneTexture.setImageData(data);
				final String msg = "loading " + sceneTexture.getPath();
				Display.getDefault().syncExec(new Runnable() {
					@Override
					public void run() {
						ProgressBarMonitor.advance(1);
						ProgressBarMonitor.labelTask(msg);
					}					
				});
			} catch (FileNotFoundException e1) {
				System.err.println("error loading " + sceneTexture.getPath());
				e1.printStackTrace();
				continue;
			}
		}
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				ModelProvider.getTextures().stream().forEach(sceneTexture -> {
					Image original;
					original = new Image(Display.getDefault(), sceneTexture.getImageData());
					Image labelImage = new Image(Display.getDefault(), original.getImageData().scaledTo(128, 32));
					sceneTexture.setLabelImage(labelImage);
					sceneTexture.setPreview(original);
					sceneTexture.getImageData().scaledTo(1, 1);
					sceneTexture.setImageData(null);
				});
				System.gc();
			}
		});
	}
	
	

	private void saveMinifiedImage(ImageData data, String path) {
		ImageLoader imageLoader = new ImageLoader();
		imageLoader.data = new ImageData[] {data};
		File directory = new File(WorkspaceConfiguration.minifiedPictureFolders);
		 if (! directory.exists())
		        directory.mkdirs();
		imageLoader.save(path, 4);
	}

	public void creatMinifield() {
		
	}

}
