package dressing.handlers.gdx;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Gdx;
import dressing.mathutils.Direction;
import dressing.mathutils.Surface;
import dressing.model.ProjectManager;
import gdxapp.Commun.GroupSelection;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.Object2D;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.room.SurfaceSelector;
import gdxapp.screens.wall.SurfaceScreen;

public class WallView {
	@Execute
	public void execute() {
		Gdx.app.postRunnable(new Runnable() {
			@Override
			public void run() {
				Surface surface = SurfaceSelector.getInstance().getSelection();
				if (surface != null) {
					SurfaceScreen wallScreenX = ProjectManager.instance.getCurrentScene().getWallScreen(surface);
					if (wallScreenX == null) {
						wallScreenX = new SurfaceScreen(surface);
					}
					Scene.game.setScreen(wallScreenX);
				}
			}
		});
		
		ToolControlHandler.getInstance().triggerSelectObject();

	}

	@CanExecute
	public boolean check() {
		return ProjectManager.getManager().getCurrentScene() != null;
	}

}
