/*
 * Decompiled with CFR 0.152.
 */
package ui.plugin.update;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.stream.Collectors;

public class UpdateService {
    private static final String baseUrl = "http://cuba.frsdev.ovh/";
    private static final String client_id = "client";
    private static final String client_secret = "secret";
    private static final String header = "Basic Y2xpZW50OnNlY3JldA==";
    private static final String client_name = "pfedemo";
    private static final String product_name = "demotycho";

    public String getAccessToken(String username, String password) {
        try {
            String jsonResponse = this.getAccessTokenRequest(username, password);
            return this.extractAccessToken(jsonResponse);
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    public String getAccessTokenRequest(String username, String password) {
        try {
            Object var11_17;
            String authHeader = header;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("client_id", client_id);
            parameters.put("client_secret", client_secret);
            parameters.put("username", username);
            parameters.put("password", password);
            parameters.put("grant_type", "password");
            String formData = parameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
            String accessTokenUrl = "http://cuba.frsdev.ovh/app/rest/v2/oauth/token";
            URL url = new URL(accessTokenUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", authHeader);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            Throwable throwable = null;
            Throwable throwable2 = null;
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.writeBytes(formData);
                wr.flush();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                throwable2 = null;
                var11_17 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    return in.lines().collect(Collectors.joining());
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            throwable2 = null;
            var11_17 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getErrorStream()));){
                return "Error: " + in.lines().collect(Collectors.joining());
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (IOException e2) {
            return "Exception: " + e2.getMessage();
        }
    }

    private String extractAccessToken(String jsonResponse) throws Exception {
        if (jsonResponse != null && !jsonResponse.startsWith("{") && !jsonResponse.isEmpty()) {
            return jsonResponse;
        }
        String tokenKey = "\"access_token\":\"";
        int start = jsonResponse.indexOf(tokenKey);
        if (start != -1) {
            int end = jsonResponse.indexOf("\"", start += tokenKey.length());
            return jsonResponse.substring(start, end);
        }
        throw new Exception("Format de r\u00e9ponse inconnu");
    }

    public boolean isAuthenticationSuccessful(String response) {
        return response != null && !response.startsWith("Error:") && !response.isEmpty() && !response.contains("exception") && !response.contains("invalid");
    }

    public String registerBuild(String token, String buildNumber) {
        try {
            String queryString = String.format("nameposte=%s&nameclient=%s&numbuild=%s&nameproduct=%s", URLEncoder.encode(InetAddress.getLocalHost().getHostName(), StandardCharsets.UTF_8), URLEncoder.encode(client_name, StandardCharsets.UTF_8), URLEncoder.encode(buildNumber, StandardCharsets.UTF_8), URLEncoder.encode(product_name, StandardCharsets.UTF_8));
            URL url = new URL("http://cuba.frsdev.ovh/app/rest/v2/services/interventionfrs_InstalledBuildService/createInstalledBuild?" + queryString);
            System.out.println("URL de la requ\u00eate: " + url.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer " + token);
            connection.setRequestProperty("Accept", "application/json");
            int responseCode = connection.getResponseCode();
            System.out.println("Code de r\u00e9ponse: " + responseCode);
            if (responseCode == 200) {
                Throwable throwable = null;
                Object var8_12 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String response = in.lines().collect(Collectors.joining());
                    System.out.println("R\u00e9ponse serveur: " + response);
                    return response;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Throwable throwable = null;
            Object var8_14 = null;
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                try {
                    String errorResponse = in.lines().collect(Collectors.joining());
                    throw new IOException("Code " + responseCode + ": " + errorResponse);
                }
                catch (Throwable throwable3) {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Erreur lors de l'enregistrement: " + e.getMessage());
            return "{\"etat\":\"ERROR\",\"message\":\"" + e.getMessage().replace("\"", "\\\"") + "\"}";
        }
    }

    public String checkLastRelease(String token, String currentBuildNumber) {
        try {
            String servicePath = "app/rest/v2/services/interventionfrs_ReadyBuildService/lastBuildClient";
            String queryParams = String.format("?nameclient=%s&numbuild=%s&nameproduct=%s", URLEncoder.encode(client_name, StandardCharsets.UTF_8), URLEncoder.encode(currentBuildNumber, StandardCharsets.UTF_8), URLEncoder.encode(product_name, StandardCharsets.UTF_8));
            URL url = new URL(baseUrl + servicePath + queryParams);
            System.out.println("[LastRelease] URL: " + url.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer " + token);
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            int responseCode = connection.getResponseCode();
            System.out.println("[LastRelease] Code HTTP: " + responseCode);
            Throwable throwable = null;
            Object var9_11 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String response = reader.lines().collect(Collectors.joining());
                System.out.println("[LastRelease] R\u00e9ponse: " + response);
                return response;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("[LastRelease] Erreur: " + e.getMessage());
            return String.format("{\"etat\":\"ERROR\",\"message\":\"%s\"}", e.getMessage().replace("\"", "\\\""));
        }
    }

    public String interpretLastReleaseResponse(String jsonResponse, String currentBuild) {
        try {
            String etat = this.extractJsonValue(jsonResponse, "etat");
            String code = this.extractJsonValue(jsonResponse, "code");
            String message = this.extractJsonValue(jsonResponse, "message");
            String serverBuild = this.extractJsonValue(jsonResponse, "value");
            if ("OK".equals(etat)) {
                return "MISE \u00c0 JOUR DISPONIBLE\nVotre version: " + currentBuild + "\nDerni\u00e8re version: " + serverBuild + "\n" + message;
            }
            if ("NOEWBUILD".equals(code)) {
                return "VOUS AVEZ LA DERNI\u00c8RE VERSION\n" + message;
            }
            if ("CONFLITBUILD".equals(code)) {
                return "VERSION PLUS R\u00c9CENTE QUE LE SERVEUR!\n" + message;
            }
            return "ERREUR: " + message;
        }
        catch (Exception e) {
            return "ERREUR D'ANALYSE: " + e.getMessage();
        }
    }

    private String extractJsonValue(String json, String key) {
        String pattern = "\"" + key + "\":\"";
        int start = json.indexOf(pattern);
        if (start == -1) {
            pattern = "\"" + key + "\":";
            start = json.indexOf(pattern);
            if (start == -1) {
                return "";
            }
            int end = json.indexOf(",", start += pattern.length());
            if (end == -1) {
                end = json.indexOf("}", start);
            }
            return json.substring(start, end).replace("\"", "");
        }
        int end = json.indexOf("\"", start += pattern.length());
        return end > start ? json.substring(start, end) : "";
    }
}

