/*
 * Decompiled with CFR 0.152.
 */
package ui.plugin.update;

import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ui.plugin.handlers.UpdateHandler;
import ui.plugin.handlers.VersionBundle;
import ui.plugin.update.UpdateService;

public class UpdateDialog
extends Dialog {
    private Text resultArea;
    private String resultMessage;
    private Button updateButton;
    private static final int DEFAULT_WIDTH = 600;
    private static final int DEFAULT_HEIGHT = 600;
    private IWorkbench workbench;
    private static final String USERNAME = "updator";
    private static final String PASSWORD = "updator";
    private IProvisioningAgent agent;

    public UpdateDialog(Shell parentShell, IWorkbench workbench, IProvisioningAgent agent) {
        super(parentShell);
        this.workbench = workbench;
        this.agent = agent;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        container.setLayout((Layout)layout);
        Button testButton = new Button(container, 8);
        testButton.setText("Tester la connexion ");
        GridData buttonData = new GridData(4, 0x1000000, true, false);
        buttonData.heightHint = 45;
        testButton.setLayoutData((Object)buttonData);
        this.resultArea = new Text(container, 2626);
        GridData textData = new GridData(4, 4, true, true);
        textData.minimumHeight = 300;
        this.resultArea.setLayoutData((Object)textData);
        this.resultArea.setEditable(false);
        this.resultArea.setBackground(Display.getDefault().getSystemColor(29));
        this.resultArea.setForeground(Display.getDefault().getSystemColor(28));
        this.updateButton = new Button(container, 8);
        this.updateButton.setText("T\u00e9l\u00e9charger la mise \u00e0 jour");
        this.updateButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.updateButton.setVisible(false);
        this.updateButton.setFont(new Font((Device)Display.getDefault(), "Arial", 10, 1));
        testButton.addListener(13, e -> {
            this.resultArea.setText("V\u00e9rification des mises \u00e0 jour en cours...");
            this.updateButton.setVisible(false);
            this.checkForUpdates();
        });
        return container;
    }

    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    protected boolean isResizable() {
        return true;
    }

    private void checkForUpdates() {
        block6: {
            String token;
            UpdateService service;
            block5: {
                service = new UpdateService();
                String username = "updator";
                String password = "updator";
                token = service.getAccessToken(username, password);
                Display.getDefault().asyncExec(() -> {
                    this.resultMessage = "CONNEXION R\u00c9USSIE\n\nToken: " + token;
                    this.resultArea.setText(this.resultMessage);
                });
                if (service.isAuthenticationSuccessful(token)) break block5;
                Display.getDefault().asyncExec(() -> this.resultArea.setText("\u00c9CHEC DE CONNEXION\n\n" + token));
                Display.getDefault().asyncExec(() -> this.resultArea.setTopIndex(0));
                return;
            }
            try {
                try {
                    System.out.println("Token obtenu: " + token);
                    String buildNumber = VersionBundle.getBuildNumber();
                    String registrationResponse = service.registerBuild(token, buildNumber);
                    String registrationMessage = this.extractJsonValue(registrationResponse, "message");
                    Display.getDefault().asyncExec(() -> {
                        this.resultMessage = registrationResponse.contains("\"etat\":\"OK\"") ? String.valueOf(this.resultMessage) + "\n\nENREGISTREMENT R\u00c9USSI\n" + registrationMessage : String.valueOf(this.resultMessage) + "\n\n\u00c9CHEC ENREGISTREMENT\n" + registrationMessage;
                        this.resultArea.setText(this.resultMessage);
                    });
                    if (!registrationResponse.contains("\"etat\":\"OK\"")) break block6;
                    String lastReleaseResponse = service.checkLastRelease(token, buildNumber);
                    String updateStatus = service.interpretLastReleaseResponse(lastReleaseResponse, buildNumber);
                    Display.getDefault().asyncExec(() -> {
                        this.resultMessage = String.valueOf(this.resultMessage) + "\n\n" + updateStatus;
                        this.resultArea.setText(this.resultMessage);
                        boolean updateAvailable = lastReleaseResponse.contains("\"etat\":\"OK\"") && !lastReleaseResponse.contains("\"code\":\"NOEWBUILD\"");
                        this.updateButton.setVisible(updateAvailable);
                        if (updateAvailable) {
                            this.updateButton.setToolTipText("Cliquez pour t\u00e9l\u00e9charger la version " + this.extractJsonValue(lastReleaseResponse, "value"));
                            String lastbuildnumber = this.extractJsonValue(lastReleaseResponse, "value");
                            UpdateHandler.setBuildNumber(lastbuildnumber);
                            this.updateButton.addListener(13, event -> {
                                UpdateHandler handler = new UpdateHandler();
                                handler.execute(this.agent, this.workbench);
                            });
                        }
                    });
                }
                catch (Exception e) {
                    Display.getDefault().asyncExec(() -> {
                        this.resultMessage = "ERREUR CRITIQUE\n" + e.getMessage();
                        this.resultArea.setText(this.resultMessage);
                    });
                    e.printStackTrace();
                    Display.getDefault().asyncExec(() -> this.resultArea.setTopIndex(0));
                }
            }
            catch (Throwable throwable) {
                Display.getDefault().asyncExec(() -> this.resultArea.setTopIndex(0));
                throw throwable;
            }
        }
        Display.getDefault().asyncExec(() -> this.resultArea.setTopIndex(0));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okButton = this.createButton(parent, 0, "Fermer", true);
        okButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Test de connexion");
        newShell.setMinimumSize(500, 350);
    }

    private String extractJsonValue(String json, String key) {
        String keyPattern = "\"" + key + "\":\"";
        int start = json.indexOf(keyPattern);
        if (start == -1) {
            return "";
        }
        int end = json.indexOf("\"", start += keyPattern.length());
        return end > start ? json.substring(start, end) : "";
    }
}

