/*
 * Decompiled with CFR 0.152.
 */
package ui.plugin.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class UpdateHandler {
    private static String REPOSITORY_LOC = "https://cadp2site.webdemo.frsdev.ovh/apps/demotycho/update/";
    private IWorkbench workbench;

    public static void setBuildNumber(String lastbuildNumber) {
        REPOSITORY_LOC = "https://cadp2site.webdemo.frsdev.ovh/apps/demotycho/update/" + lastbuildNumber;
        System.out.println("URL de mise \u00e0 jour configur\u00e9e : " + REPOSITORY_LOC);
        System.out.println("URL de mise \u00e0 jour configur\u00e9e : " + REPOSITORY_LOC);
    }

    public void execute(IProvisioningAgent agent, IWorkbench workbench) {
        this.workbench = workbench;
        System.out.println("D\u00e9but du processus de mise \u00e0 jour");
        Job updateJob = Job.create((String)"Recherche de mises \u00e0 jour", monitor -> {
            IStatus status = this.performUpdates(agent, monitor);
            if (!status.isOK()) {
                Display.getDefault().asyncExec(() -> MessageDialog.openError(null, (String)"Erreur", (String)("\u00c9chec de la mise \u00e0 jour: " + status.getMessage())));
            }
        });
        updateJob.schedule();
    }

    private IStatus performUpdates(IProvisioningAgent agent, IProgressMonitor monitor) {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        try {
            URI uri = new URI(REPOSITORY_LOC);
            operation.getProvisioningContext().setArtifactRepositories(new URI[]{uri});
            operation.getProvisioningContext().setMetadataRepositories(new URI[]{uri});
            IStatus status = operation.resolveModal(monitor);
            if (status.getCode() == 10000) {
                Display.getDefault().asyncExec(() -> MessageDialog.openInformation(null, (String)"Mise \u00e0 jour", (String)"Aucune mise \u00e0 jour disponible."));
                return Status.CANCEL_STATUS;
            }
            boolean userConfirmed = (Boolean)Display.getDefault().syncCall(() -> MessageDialog.openQuestion(null, (String)"Mise \u00e0 jour disponible", (String)"Une mise \u00e0 jour est disponible. Voulez-vous l'installer ?"));
            if (!userConfirmed) {
                return Status.CANCEL_STATUS;
            }
            ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
            if (provisioningJob == null) {
                return Status.CANCEL_STATUS;
            }
            this.configureProvisioningJob(provisioningJob);
            provisioningJob.schedule();
            return Status.OK_STATUS;
        }
        catch (URISyntaxException e) {
            throw new OperationCanceledException("Emplacement du d\u00e9p\u00f4t invalide: " + REPOSITORY_LOC);
        }
    }

    private void configureProvisioningJob(ProvisioningJob provisioningJob) {
        provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Mise \u00e0 jour termin\u00e9e avec succ\u00e8s, red\u00e9marrage de l'application...");
                    Display.getDefault().asyncExec(() -> {
                        boolean restartConfirmed = MessageDialog.openQuestion(null, (String)"Red\u00e9marrage n\u00e9cessaire", (String)"La mise \u00e0 jour a \u00e9t\u00e9 install\u00e9e avec succ\u00e8s.\nL'application doit red\u00e9marrer pour appliquer les changements.\n\nRed\u00e9marrer maintenant ?");
                        if (restartConfirmed) {
                            UpdateHandler.this.workbench.restart();
                        }
                    });
                } else {
                    Display.getDefault().asyncExec(() -> MessageDialog.openError(null, (String)"Erreur", (String)("\u00c9chec de l'installation de la mise \u00e0 jour:\n" + event.getResult().getMessage())));
                }
            }
        });
    }
}

