/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.di.internal.extensions;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PreDestroy;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@Component(service={ExtendedObjectSupplier.class, EventHandler.class}, property={"dependency.injection.annotation=org.eclipse.e4.core.di.extensions.EventTopic", "event.topics=org/eclipse/e4/core/contexts/IEclipseContext/DISPOSE"}, immediate=true)
public class EventObjectSupplier
extends ExtendedObjectSupplier
implements EventHandler {
    public static final String DATA = "org.eclipse.e4.data";
    private EventAdmin eventAdmin;
    protected Map<String, Event> currentEvents = new HashMap<String, Event>();
    private Map<Subscriber, ServiceRegistration<EventHandler>> registrations = new HashMap<Subscriber, ServiceRegistration<EventHandler>>();

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    @Reference
    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCurrentEvent(String topic, Event event) {
        Map<String, Event> map = this.currentEvents;
        synchronized (map) {
            this.currentEvents.put(topic, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCurrentEvent(String topic) {
        Map<String, Event> map = this.currentEvents;
        synchronized (map) {
            this.currentEvents.remove(topic);
        }
    }

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        if (descriptor == null) {
            return null;
        }
        String topic = this.getTopic(descriptor);
        if (topic == null || this.eventAdmin == null || topic.isEmpty()) {
            return IInjector.NOT_A_VALUE;
        }
        if (track) {
            this.subscribe(topic, requestor);
        } else {
            this.unsubscribe(requestor);
        }
        if (!this.currentEvents.containsKey(topic)) {
            return IInjector.NOT_A_VALUE;
        }
        Class<?> descriptorsClass = this.getDesiredClass(descriptor.getDesiredType());
        if (descriptorsClass.equals(Event.class)) {
            return this.currentEvents.get(topic);
        }
        return this.currentEvents.get(topic).getProperty(DATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribe(String topic, IRequestor requestor) {
        Subscriber subscriber = new Subscriber(requestor, topic);
        Map<Subscriber, ServiceRegistration<EventHandler>> map = this.registrations;
        synchronized (map) {
            if (this.registrations.containsKey(subscriber)) {
                return;
            }
        }
        BundleContext bundleContext = FrameworkUtil.getBundle(EventObjectSupplier.class).getBundleContext();
        if (bundleContext == null) {
            throw new InjectionException("Unable to subscribe to events: org.eclipse.e4.core.di.extensions bundle is not activated");
        }
        String[] topics = new String[]{topic};
        Hashtable<String, String[]> d = new Hashtable<String, String[]>();
        ((Dictionary)d).put("event.topics", topics);
        EventHandler wrappedHandler = this.makeHandler(topic, requestor);
        ServiceRegistration registration = bundleContext.registerService(EventHandler.class, (Object)wrappedHandler, d);
        Map<Subscriber, ServiceRegistration<EventHandler>> map2 = this.registrations;
        synchronized (map2) {
            this.registrations.put(subscriber, (ServiceRegistration<EventHandler>)registration);
        }
    }

    protected EventHandler makeHandler(String topic, IRequestor requestor) {
        return new DIEventHandler(topic, requestor);
    }

    protected String getTopic(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        EventTopic qualifier = (EventTopic)descriptor.getQualifier(EventTopic.class);
        return qualifier.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribe(IRequestor requestor) {
        if (requestor == null) {
            return;
        }
        Map<Subscriber, ServiceRegistration<EventHandler>> map = this.registrations;
        synchronized (map) {
            Iterator<Map.Entry<Subscriber, ServiceRegistration<EventHandler>>> i = this.registrations.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Subscriber, ServiceRegistration<EventHandler>> entry = i.next();
                Subscriber key = entry.getKey();
                if (!requestor.equals(key.getRequestor())) continue;
                ServiceRegistration<EventHandler> registration = entry.getValue();
                registration.unregister();
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void dispose() {
        ServiceRegistration[] array;
        Map<Subscriber, ServiceRegistration<EventHandler>> map = this.registrations;
        synchronized (map) {
            Collection<ServiceRegistration<EventHandler>> values = this.registrations.values();
            array = values.toArray(new ServiceRegistration[values.size()]);
            this.registrations.clear();
        }
        ServiceRegistration[] serviceRegistrationArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceRegistration element = serviceRegistrationArray[n2];
            element.unregister();
            ++n2;
        }
    }

    private Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        Map<Subscriber, ServiceRegistration<EventHandler>> map = this.registrations;
        synchronized (map) {
            Iterator<Map.Entry<Subscriber, ServiceRegistration<EventHandler>>> i = this.registrations.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Subscriber, ServiceRegistration<EventHandler>> entry = i.next();
                Subscriber key = entry.getKey();
                if (key.getRequestor().isValid()) continue;
                ServiceRegistration<EventHandler> registration = entry.getValue();
                registration.unregister();
                i.remove();
            }
        }
    }

    class DIEventHandler
    implements EventHandler {
        private final IRequestor requestor;
        private final String topic;

        public DIEventHandler(String topic, IRequestor requestor) {
            this.topic = topic;
            this.requestor = requestor;
        }

        public void handleEvent(Event event) {
            if (!this.requestor.isValid()) {
                EventObjectSupplier.this.unsubscribe(this.requestor);
                return;
            }
            EventObjectSupplier.this.addCurrentEvent(this.topic, event);
            this.requestor.resolveArguments(false);
            EventObjectSupplier.this.removeCurrentEvent(this.topic);
            this.requestor.execute();
        }
    }

    private static class Subscriber {
        private IRequestor requestor;
        private String topic;

        public Subscriber(IRequestor requestor, String topic) {
            this.requestor = requestor;
            this.topic = topic;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.requestor);
            return 31 * result + Objects.hashCode(this.topic);
        }

        public IRequestor getRequestor() {
            return this.requestor;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Subscriber other = (Subscriber)obj;
            return Objects.equals(this.requestor, other.requestor) && Objects.equals(this.topic, other.topic);
        }
    }
}

