/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;
import java.util.Objects;
import org.eclipse.core.databinding.conversion.Converter;

public class AbstractNumberToStringConverter
extends Converter<Object, String> {
    private final Format numberFormat;
    private final Class<?> fromType;
    private boolean fromTypeFitsLong;
    private boolean fromTypeIsDecimalType;
    private boolean fromTypeIsBigInteger;
    private boolean fromTypeIsBigDecimal;
    static Class<?> icuBigDecimal = null;
    static Constructor<?> icuBigDecimalCtr = null;
    static Class<?> icuDecimalFormat = null;

    protected AbstractNumberToStringConverter(Format numberFormat, Class<?> fromType) {
        super(fromType, String.class);
        try {
            icuBigDecimal = Class.forName("com.ibm.icu.math.BigDecimal");
            icuBigDecimalCtr = icuBigDecimal.getConstructor(BigInteger.class, Integer.TYPE);
            icuDecimalFormat = Class.forName("com.ibm.icu.text.DecimalFormat");
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {}
        this.numberFormat = Objects.requireNonNull(numberFormat);
        this.fromType = Objects.requireNonNull(fromType);
        if (Integer.class.equals(fromType) || Integer.TYPE.equals(fromType) || Long.class.equals(fromType) || Long.TYPE.equals(fromType) || Short.class.equals(fromType) || Short.TYPE.equals(fromType) || Byte.class.equals(fromType) || Byte.TYPE.equals(fromType)) {
            this.fromTypeFitsLong = true;
        } else if (Float.class.equals(fromType) || Float.TYPE.equals(fromType) || Double.class.equals(fromType) || Double.TYPE.equals(fromType)) {
            this.fromTypeIsDecimalType = true;
        } else if (BigInteger.class.equals(fromType)) {
            this.fromTypeIsBigInteger = true;
        } else if (BigDecimal.class.equals(fromType)) {
            this.fromTypeIsBigDecimal = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convert(Object fromObject) {
        if (fromObject == null && !this.fromType.isPrimitive()) {
            return "";
        }
        Number number = (Number)fromObject;
        String result = null;
        if (this.fromTypeFitsLong) {
            Format format = this.numberFormat;
            synchronized (format) {
                result = this.numberFormat.format(number.longValue());
            }
        }
        if (this.fromTypeIsDecimalType) {
            Format format = this.numberFormat;
            synchronized (format) {
                result = this.numberFormat.format(number.doubleValue());
            }
        }
        if (this.fromTypeIsBigInteger) {
            Format format = this.numberFormat;
            synchronized (format) {
                result = this.numberFormat.format(number);
            }
        }
        if (this.fromTypeIsBigDecimal) {
            if (icuBigDecimal != null && icuBigDecimalCtr != null && icuDecimalFormat != null && icuDecimalFormat.isInstance(this.numberFormat)) {
                BigDecimal o = (BigDecimal)fromObject;
                try {
                    fromObject = icuBigDecimalCtr.newInstance(o.unscaledValue(), o.scale());
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {}
            }
            Format format = this.numberFormat;
            synchronized (format) {
                result = this.numberFormat.format(fromObject);
            }
        }
        return result;
    }
}

