/*
 * Decompiled with CFR 0.152.
 */
package ui.plugin.update;

import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisioningAgentManager {
    private static final Logger logger = LoggerFactory.getLogger(ProvisioningAgentManager.class);
    private static volatile IProvisioningAgent instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IProvisioningAgent getProvisioningAgent() {
        if (instance != null) return instance;
        Class<ProvisioningAgentManager> clazz = ProvisioningAgentManager.class;
        synchronized (ProvisioningAgentManager.class) {
            if (instance != null) return instance;
            instance = ProvisioningAgentManager.obtainProvisioningAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IProvisioningAgent obtainProvisioningAgent() {
        BundleContext context = ProvisioningAgentManager.getBundleContext();
        if (context == null) {
            logger.error("Cannot obtain BundleContext");
            return null;
        }
        try {
            ServiceReference agentRef;
            ServiceReference providerRef = context.getServiceReference(IProvisioningAgentProvider.class);
            if (providerRef != null) {
                IProvisioningAgentProvider provider = (IProvisioningAgentProvider)context.getService(providerRef);
                try {
                    IProvisioningAgent agent = provider.createAgent(null);
                    logger.info("Provisioning Agent obtained via IProvisioningAgentProvider");
                    IProvisioningAgent iProvisioningAgent = agent;
                    return iProvisioningAgent;
                }
                catch (Exception e) {
                    logger.error("Error creating agent via provider", (Throwable)e);
                }
                finally {
                    context.ungetService(providerRef);
                }
            }
            if ((agentRef = context.getServiceReference(IProvisioningAgent.class)) != null) {
                IProvisioningAgent agent = (IProvisioningAgent)context.getService(agentRef);
                context.ungetService(agentRef);
                if (agent != null) {
                    logger.info("Provisioning Agent obtained via direct service lookup");
                    return agent;
                }
            }
            logger.error("Unable to obtain Provisioning Agent");
            return null;
        }
        catch (Exception e) {
            logger.error("Critical error obtaining Provisioning Agent", (Throwable)e);
            return null;
        }
    }

    private static BundleContext getBundleContext() {
        try {
            return FrameworkUtil.getBundle(ProvisioningAgentManager.class).getBundleContext();
        }
        catch (Exception e) {
            logger.error("Cannot retrieve BundleContext", (Throwable)e);
            return null;
        }
    }

    public static boolean isProvisioningAgentAvailable() {
        return ProvisioningAgentManager.getProvisioningAgent() != null;
    }

    public static void logProvisioningAgentDiagnostics() {
        BundleContext context = ProvisioningAgentManager.getBundleContext();
        if (context == null) {
            logger.error("No BundleContext available for diagnostics");
            return;
        }
        try {
            ServiceReference envRef = context.getServiceReference(EnvironmentInfo.class);
            if (envRef != null) {
                EnvironmentInfo env = (EnvironmentInfo)context.getService(envRef);
                logger.info("OS: {}, Architecture: {}", (Object)env.getOS(), (Object)env.getOSArch());
                context.ungetService(envRef);
            }
            logger.info("Provisioning Agent Available: {}", (Object)ProvisioningAgentManager.isProvisioningAgentAvailable());
        }
        catch (Exception e) {
            logger.error("Error during provisioning agent diagnostics", (Throwable)e);
        }
    }
}

